
// define our varying texture coordinates
varying vec2 texcoord0;
varying vec2 texcoord1;

// define our rectangular texture samplers
uniform sampler2DRect tex0;
uniform sampler2DRect tex1;

void main (void)
{
	// sample our textures
	vec4 input0 = texture2DRect(tex0, texcoord0);
	float input1 = texture2DRect(tex1, texcoord1).x;
	
	// create new output (r, g, b, a)
	vec4 spots_fc = vec4(input0.x, input0.y, input0.z, input1);
	
	// write our data to the fragment color
	gl_FragColor = spots_fc;
}
